<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Skill;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;

class SkillController extends Controller
{
    public function index(Request $request): View
    {
        $query = Skill::query();
        if ($q = $request->string('q')->toString()) {
            $query->where('skill_name','like',"%{$q}%");
        }
        $skills = $query->latest('id')->paginate(20)->withQueryString();
        return view('admin.skills.index', compact('skills'));
    }
}


