<?php

namespace App\Http\Controllers\Company;

use App\Http\Controllers\Controller;
use App\Models\Job;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PortalController extends Controller
{
    public function dashboard()
    {
        $user = Auth::user();
        $company = $user->company;
        if (!$company) {
            return redirect()->route('register.company.show');
        }
        $jobsCount = $company ? $company->jobs()->count() : 0;
        $applicationsCount = $company ? \App\Models\JobApplication::whereIn('job_id', $company->jobs()->pluck('id'))->count() : 0;
        return view('company.dashboard', compact('company','jobsCount','applicationsCount'));
    }

    public function jobs()
    {
        $company = Auth::user()->company;
        $jobs = $company ? $company->jobs()->latest('id')->paginate(12) : collect();
        return view('company.jobs.index', compact('jobs'));
    }

    public function jobApplications($jobId)
    {
        $company = Auth::user()->company;
        $job = Job::where('id', $jobId)->where('company_id', $company? $company->id : 0)->firstOrFail();
        $applications = $job->applications()->with('jobSeeker.user')->latest('id')->paginate(20);
        return view('company.jobs.applications', compact('job','applications'));
    }
}
