<?php

namespace App\Http\Controllers\Company;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SettingsController extends Controller
{
    public function edit()
    {
        $company = Auth::user()->company;
        return view('company.settings.edit', compact('company'));
    }

    public function update(Request $request)
    {
        $company = Auth::user()->company;
        $data = $request->validate([
            'company_name' => ['required','string','max:100'],
            'industry' => ['nullable','string','max:50'],
            'company_phone' => ['nullable','string','max:20'],
            'location' => ['nullable','string','max:100'],
            'company_description' => ['nullable','string'],
        ]);
        if ($company) {
            $company->update($data);
        }
        return redirect()->route('company.dashboard')->with('success','تم تحديث بيانات الشركة');
    }
}
