<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminOnly
{
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            return redirect()->route('login.show');
        }
        // Only allow admin to access admin area (user_type === 'admin' or 'superadmin')
        $u = Auth::user();
        if (!isset($u->user_type) || ($u->user_type !== 'admin' && $u->user_type !== 'superadmin')) {
            return redirect('/');
        }
        return $next($request);
    }
}


