<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class JobSeekerOnly
{
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            return redirect()->route('login.show');
        }
        if (Auth::user()->user_type !== 'jobseeker') {
            return redirect('/');
        }
        return $next($request);
    }
}


