<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\Company;
use App\Models\JobSeeker;
use App\Policies\CompanyPolicy;
use App\Policies\JobSeekerPolicy;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // register policies
        Gate::policy(Company::class, CompanyPolicy::class);
        Gate::policy(JobSeeker::class, JobSeekerPolicy::class);
    }
}
