<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('job_seekers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->enum('experience_years', ['0-1','2-3','4-5','6+'])->default('0-1');
            $table->text('skills')->nullable();
            $table->string('resume_file', 255)->nullable();
            $table->string('current_position', 100)->nullable();
            $table->decimal('desired_salary', 10, 2)->nullable();
            $table->string('preferred_location', 100)->nullable();
            $table->enum('education_level', ['high_school','bachelor','master','phd','other'])->default('bachelor');
            $table->text('languages')->nullable();
            $table->text('certifications')->nullable();
            $table->timestamps();

            $table->index('experience_years', 'idx_experience_years');
            $table->index('preferred_location', 'idx_preferred_location');
            $table->index('education_level', 'idx_education_level');
        });

        Schema::create('job_applications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('job_id')->constrained('jobs')->cascadeOnDelete();
            $table->foreignId('job_seeker_id')->constrained('job_seekers')->cascadeOnDelete();
            $table->text('cover_letter')->nullable();
            $table->string('resume_file', 255)->nullable();
            $table->enum('status', ['pending','reviewed','shortlisted','interview','accepted','rejected'])->default('pending');
            $table->timestamp('applied_at')->useCurrent();
            $table->timestamp('reviewed_at')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->unique(['job_id','job_seeker_id'], 'unique_application');
            $table->index('status', 'idx_status');
            $table->index('applied_at', 'idx_applied_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('job_applications');
        Schema::dropIfExists('job_seekers');
    }
};


