<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('event_title', 200);
            $table->text('event_description');
            $table->date('event_date');
            $table->time('event_time');
            $table->string('location', 200);
            $table->enum('event_type', ['workshop','seminar','job_fair','networking','conference'])->default('workshop');
            $table->integer('capacity')->default(0);
            $table->integer('registered_count')->default(0);
            $table->string('featured_image', 255)->nullable();
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->index('event_title', 'idx_event_title');
            $table->index('event_date', 'idx_event_date');
            $table->index('event_type', 'idx_event_type');
            $table->index('location', 'idx_location');
            $table->index('is_featured', 'idx_is_featured');
            $table->index('is_active', 'idx_is_active');
        });

        Schema::create('event_registrations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->constrained('events')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->timestamp('registration_date')->useCurrent();
            $table->enum('attendance_status', ['registered','attended','no_show','cancelled'])->default('registered');
            $table->unsignedTinyInteger('feedback_rating')->nullable();
            $table->text('feedback_comment')->nullable();
            $table->timestamps();

            $table->unique(['event_id','user_id'], 'unique_registration');
            $table->index('attendance_status', 'idx_attendance_status');
            $table->index('registration_date', 'idx_registration_date');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('event_registrations');
        Schema::dropIfExists('events');
    }
};


