@extends('admin.layouts.app')
@section('title','تعديل طلب توظيف')
@section('page-title','تعديل طلب توظيف')
@section('content')
<form method="post" action="{{ route('admin.applications.update',$application) }}" class="card" style="max-width:920px">
@csrf
@method('put')
<div class="grid" style="grid-template-columns:1fr 1fr">
    <label>الوظيفة
        <select name="job_id" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach($jobs as $id=>$title)
                <option value="{{ $id }}" @selected($application->job_id==$id)>{{ $title }}</option>
            @endforeach
        </select>
    </label>
    <label>المتقدم
        <select name="job_seeker_id" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach($seekers as $id=>$email)
                <option value="{{ $id }}" @selected($application->job_seeker_id==$id)>{{ $email }}</option>
            @endforeach
        </select>
    </label>
    <label>الحالة
        <select name="status" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            @foreach(['pending','reviewed','shortlisted','interview','accepted','rejected'] as $s)
                <option value="{{ $s }}" @selected($application->status==$s)>{{ $s }}</option>
            @endforeach
        </select>
    </label>
    <label>تاريخ التقديم<input type="datetime-local" name="applied_at" value="{{ optional($application->applied_at)->format('Y-m-d\TH:i') }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label style="grid-column:1/-1">خطاب التغطية<textarea name="cover_letter" rows="4" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">{{ $application->cover_letter }}</textarea></label>
    <label>ملف السيرة (رابط)<input name="resume_file" value="{{ $application->resume_file }}" placeholder="/storage/resumes/.." style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
    <label style="grid-column:1/-1">ملاحظات<textarea name="notes" rows="3" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">{{ $application->notes }}</textarea></label>
</div>
<div style="margin-top:12px">
    <button class="btn" type="submit">حفظ</button>
    <a class="btn" href="{{ route('admin.applications.index') }}">إلغاء</a>
    </div>
</form>
@endsection


