@extends('admin.layouts.app')
@section('title','طلبات التوظيف')
@section('page-title','طلبات التوظيف')
@section('content')
<div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:16px">
    <form method="get" action="" style="display:flex;gap:8px">
        <select name="status" style="background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            <option value="">الكل</option>
            @foreach(['pending','reviewed','shortlisted','interview','accepted','rejected'] as $s)
                <option value="{{ $s }}" @selected(request('status')===$s)>{{ $s }}</option>
            @endforeach
        </select>
        <button class="btn" type="submit">تصفية</button>
    </form>
    <a class="btn" href="{{ route('admin.applications.create') }}"><i class="fa-solid fa-plus"></i> طلب جديد</a>
    </div>
<table class="table">
    <thead><tr><th>الوظيفة</th><th>المتقدم</th><th>الحالة</th><th>بتاريخ</th><th></th></tr></thead>
    <tbody>
    @foreach($applications as $app)
        <tr>
            <td>{{ optional($app->job)->job_title }}</td>
            <td>{{ optional(optional($app->jobSeeker)->user)->email }}</td>
            <td><span class="badge">{{ $app->status }}</span></td>
            <td>{{ $app->applied_at }}</td>
            <td style="text-align:end">
                <a class="btn" href="{{ route('admin.applications.edit',$app) }}">تعديل</a>
                <form action="{{ route('admin.applications.destroy',$app) }}" method="post" style="display:inline-block" onsubmit="return confirm('حذف الطلب؟');">
                    @csrf
                    @method('delete')
                    <button class="btn" type="submit">حذف</button>
                </form>
            </td>
        </tr>
    @endforeach
    </tbody>
</table>
<div style="margin-top:12px">{{ $applications->links() }}</div>
@endsection


