@extends('admin.layouts.app')

@section('title','تعديل شركة')
@section('page-title','تعديل شركة')

@section('content')
    <form method="post" action="{{ route('admin.companies.update',$company) }}" class="card" style="max-width:860px">
        @csrf
        @method('put')
        <div class="grid" style="grid-template-columns:1fr 1fr">
            <label>العميل (يوزر الشركة)
                <select name="user_id" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
                    @foreach($users as $id=>$email)
                        <option value="{{ $id }}" @selected($company->user_id==$id)>{{ $email }}</option>
                    @endforeach
                </select>
            </label>
            <label>اسم الشركة<input name="company_name" value="{{ $company->company_name }}" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
            <label>القطاع<input name="industry" value="{{ $company->industry }}" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
            <label>البريد الإلكتروني<input name="company_email" type="email" value="{{ $company->company_email }}" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
            <label>الهاتف<input name="company_phone" value="{{ $company->company_phone }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
            <label>الموقع الإلكتروني<input name="company_website" value="{{ $company->company_website }}" placeholder="https://" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
            <label>حجم الشركة
                <select name="company_size" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
                    @foreach(['1-10','11-50','51-200','201-500','500+'] as $size)
                        <option value="{{ $size }}" @selected($company->company_size==$size)>{{ $size }}</option>
                    @endforeach
                </select>
            </label>
            <label>المدينة<input name="location" value="{{ $company->location }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
            <label>التقييم<input name="rating" type="number" step="0.01" min="0" max="5" value="{{ $company->rating }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
            <label style="display:flex;align-items:center;gap:8px;margin-top:26px"><input type="checkbox" name="is_verified" value="1" @checked($company->is_verified)> موثّقة</label>
            <label style="grid-column:1/-1">الوصف<textarea name="company_description" rows="4" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">{{ $company->company_description }}</textarea></label>
        </div>
        <div style="margin-top:12px">
            <button class="btn" type="submit"><i class="fa-solid fa-save"></i> حفظ</button>
            <a class="btn" href="{{ route('admin.companies.index') }}">إلغاء</a>
        </div>
    </form>
@endsection


