@extends('admin.layouts.app')
@section('title','المتقدمون للوظائف')
@section('page-title','المتقدمون للوظائف')
@section('content')
<div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:16px">
    <form method="get" action="" style="display:flex;gap:8px">
        <input name="q" value="{{ request('q') }}" placeholder="ابحث بالبريد أو الاسم" style="background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px 12px;border-radius:10px;min-width:260px">
        <button class="btn" type="submit">بحث</button>
    </form>
    <a class="btn" href="{{ route('admin.job-seekers.create') }}"><i class="fa-solid fa-plus"></i> متقدم جديد</a>
</div>
<table class="table">
    <thead><tr><th>البريد</th><th>الاسم</th><th>الخبرة</th><th>المدينة</th><th></th></tr></thead>
    <tbody>
    @foreach($seekers as $s)
        <tr>
            <td>{{ optional($s->user)->email }}</td>
            <td>{{ optional($s->user)->first_name }} {{ optional($s->user)->last_name }}</td>
            <td>{{ $s->experience_years }}</td>
            <td>{{ $s->preferred_location }}</td>
            <td style="text-align:end">
                <a class="btn" href="{{ route('admin.job-seekers.edit',$s) }}">تعديل</a>
                <a class="btn" href="{{ route('admin.job-seekers.show',$s) }}">عرض</a>
                <form action="{{ route('admin.job-seekers.destroy',$s) }}" method="post" style="display:inline-block" onsubmit="return confirm('حذف المتقدم؟');">
                    @csrf
                    @method('delete')
                    <button class="btn" type="submit">حذف</button>
                </form>
            </td>
        </tr>
    @endforeach
    </tbody>
</table>
<div style="margin-top:12px">{{ $seekers->links() }}</div>
@endsection


