@extends('admin.layouts.app')
@section('title','عرض متقدم')
@section('page-title','عرض متقدم')
@section('content')
<div class="grid" style="grid-template-columns:2fr 1fr;gap:16px">
    <div class="card">
        <div><strong>البريد:</strong> {{ optional($seeker->user)->email }}</div>
        <div><strong>الاسم:</strong> {{ optional($seeker->user)->first_name }} {{ optional($seeker->user)->last_name }}</div>
        <div><strong>الخبرة:</strong> {{ $seeker->experience_years }}</div>
        <div><strong>المدينة المفضلة:</strong> {{ $seeker->preferred_location }}</div>
        <div style="margin-top:12px"><strong>المهارات</strong><div style="white-space:pre-wrap">{{ $seeker->skills }}</div></div>
        <div style="margin-top:12px"><strong>اللغات</strong><div style="white-space:pre-wrap">{{ $seeker->languages }}</div></div>
        <div style="margin-top:12px"><strong>الشهادات</strong><div style="white-space:pre-wrap">{{ $seeker->certifications }}</div></div>
    </div>
    <div class="card">
        <a class="btn" href="{{ route('admin.job-seekers.edit',$seeker) }}">تعديل</a>
        @if($seeker->resume_file)
            <div style="margin-top:12px"><a class="btn" href="{{ $seeker->resume_file }}" target="_blank">عرض السيرة</a></div>
        @endif
    </div>
</div>

<div style="height:16px"></div>
<div class="card">
    <strong>طلبات التوظيف الأخيرة</strong>
    <table class="table" style="margin-top:8px">
        <thead><tr><th>الوظيفة</th><th>الحالة</th><th>بتاريخ</th></tr></thead>
        <tbody>
        @foreach($seeker->applications()->with('job')->latest('id')->limit(10)->get() as $app)
            <tr>
                <td>{{ optional($app->job)->job_title }}</td>
                <td><span class="badge">{{ $app->status }}</span></td>
                <td>{{ $app->applied_at }}</td>
            </tr>
        @endforeach
        </tbody>
    </table>
</div>
@endsection


