@extends('admin.layouts.app')
@section('title','المستخدمون')
@section('page-title','المستخدمون')
@section('content')
<div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:16px">
    <form method="get" action="" style="display:flex;gap:8px">
        <select name="type" style="background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
            <option value="">الكل</option>
            @foreach(['admin'=>'أدمن','company'=>'شركة','jobseeker'=>'متقدم'] as $k=>$v)
                <option value="{{ $k }}" @selected(request('type')===$k)>{{ $v }}</option>
            @endforeach
        </select>
        <input name="q" value="{{ request('q') }}" placeholder="ابحث بالبريد أو الاسم" style="background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px 12px;border-radius:10px;min-width:260px">
        <button class="btn" type="submit">تصفية</button>
    </form>
    <a class="btn" href="{{ route('admin.users.create') }}"><i class="fa-solid fa-plus"></i> مستخدم جديد</a>
</div>
<table class="table">
    <thead><tr><th>الاسم</th><th>البريد</th><th>النوع</th><th>نشط</th><th></th></tr></thead>
    <tbody>
    @foreach($users as $u)
        <tr>
            <td>{{ $u->first_name }} {{ $u->last_name }}</td>
            <td>{{ $u->email }}</td>
            <td>{{ $u->user_type }}</td>
            <td>{!! $u->is_active ? '<span class="badge">نعم</span>' : '<span class="badge">لا</span>' !!}</td>
            <td style="text-align:end">
                <a class="btn" href="{{ route('admin.users.edit',$u) }}">تعديل</a>
                <form action="{{ route('admin.users.destroy',$u) }}" method="post" style="display:inline-block" onsubmit="return confirm('حذف المستخدم؟');">
                    @csrf
                    @method('delete')
                    <button class="btn" type="submit">حذف</button>
                </form>
            </td>
        </tr>
    @endforeach
    </tbody>
 </table>
 <div style="margin-top:12px">{{ $users->links() }}</div>
@endsection


