<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>تسجيل باحث عن عمل - Master‑HR</title>
    <link rel="stylesheet" href="/admin.css">
</head>
<body style="display:flex;align-items:center;justify-content:center;min-height:100vh">
<form method="post" action="{{ route('register.jobseeker.perform') }}" class="card" style="width:520px">
    @csrf
    <h2 style="margin:0 0 12px">تسجيل باحث عن عمل</h2>

    @if(session('status'))
        <div style="background:#e6fffa;padding:8px;border-radius:6px;margin-bottom:12px;color:#064e3b">{{ session('status') }}</div>
    @endif

    @if($errors->any())
        <div style="background:#fff1f2;padding:10px;border-radius:6px;margin-bottom:12px;color:#7f1d1d">
            <strong>وجدت أخطاء:</strong>
            <ul style="margin:6px 0 0;padding-left:18px">
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="grid" style="grid-template-columns:1fr 1fr">
        <label>الاسم الأول<input name="first_name" value="{{ old('first_name') }}" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>الاسم الأخير<input name="last_name" value="{{ old('last_name') }}" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>اسم المستخدم<input name="username" value="{{ old('username') }}" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>البريد<input name="email" value="{{ old('email') }}" type="email" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>كلمة المرور<input name="password" type="password" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>تأكيد كلمة المرور<input name="password_confirmation" type="password" required style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label style="grid-column:1/-1">المدينة المفضلة<input name="preferred_location" value="{{ old('preferred_location') }}" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px"></label>
        <label>التعليم
            <select name="education_level" style="width:100%;background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px;border-radius:10px">
                @foreach(['high_school'=>'ثانوية','bachelor'=>'بكالوريوس','master'=>'ماجستير','phd'=>'دكتوراه','other'=>'أخرى'] as $k=>$v)
                    <option value="{{ $k }}" {{ old('education_level')==$k? 'selected':'' }}>{{ $v }}</option>
                @endforeach
            </select>
        </label>
    </div>
    <div style="height:12px"></div>
    <button class="btn" type="submit" style="width:100%">تسجيل</button>
    <div style="margin-top:8px;text-align:center"><a href="/">عودة للموقع</a></div>
 </form>
</body>
</html>


