@extends('frontend.layout')
@section('title','إعدادات الشركة')
@section('content')
<div class="container py-4">
    <h3>إعدادات الشركة</h3>
    <form method="post" action="{{ route('company.settings.update') }}">
        @csrf
        <div class="mb-3">
            <label>اسم الشركة</label>
            <input name="company_name" value="{{ old('company_name', $company->company_name ?? '') }}" class="form-control" />
        </div>
        <div class="mb-3">
            <label>الهاتف</label>
            <input name="company_phone" value="{{ old('company_phone', $company->company_phone ?? '') }}" class="form-control" />
        </div>
        <div class="mb-3">
            <label>الموقع</label>
            <input name="location" value="{{ old('location', $company->location ?? '') }}" class="form-control" />
        </div>
        <div class="mb-3">
            <label>وصف الشركة</label>
            <textarea name="company_description" class="form-control">{{ old('company_description', $company->company_description ?? '') }}</textarea>
        </div>
        <button class="btn btn-primary">حفظ</button>
    </form>
</div>
@endsection
