

<?php $__env->startSection('title','لوحة التحكم'); ?>
<?php $__env->startSection('page-title','نظرة عامة'); ?>

<?php $__env->startSection('content'); ?>
    <div class="grid grid-4">
        <div class="card stat">
            <div>
                <div class="muted">عدد الشركات</div>
                <div style="font-size:28px;font-weight:800"><?php echo e(number_format(\App\Models\Company::count())); ?></div>
            </div>
            <i class="fa-solid fa-buildings" style="color:#38bdf8;font-size:28px"></i>
        </div>
        <div class="card stat">
            <div>
                <div class="muted">عدد الوظائف</div>
                <div style="font-size:28px;font-weight:800"><?php echo e(number_format(\App\Models\Job::count())); ?></div>
            </div>
            <i class="fa-solid fa-clipboard-list" style="color:#22d3ee;font-size:28px"></i>
        </div>
        <div class="card stat">
            <div>
                <div class="muted">طلبات التوظيف</div>
                <div style="font-size:28px;font-weight:800"><?php echo e(number_format(\App\Models\JobApplication::count())); ?></div>
            </div>
            <i class="fa-solid fa-paper-plane" style="color:#60a5fa;font-size:28px"></i>
        </div>
        <div class="card stat">
            <div>
                <div class="muted">المستخدمون</div>
                <div style="font-size:28px;font-weight:800"><?php echo e(number_format(\App\Models\User::count())); ?></div>
            </div>
            <i class="fa-solid fa-users" style="color:#818cf8;font-size:28px"></i>
        </div>
    </div>
    <div style="height:16px"></div>
    <div class="grid" style="grid-template-columns:2fr 1fr">
        <div class="card">
            <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:10px">
                <strong>أحدث الوظائف</strong>
                <a class="btn" href="<?php echo e(route('admin.jobs.index')); ?>">المزيد</a>
            </div>
            <table class="table">
                <thead>
                <tr>
                    <th>العنوان</th>
                    <th>الشركة</th>
                    <th>المدينة</th>
                    <th>تاريخ الإضافة</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = \App\Models\Job::with('company')->latest('id')->limit(6)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($job->job_title); ?></td>
                        <td><?php echo e(optional($job->company)->company_name); ?></td>
                        <td><?php echo e($job->location); ?></td>
                        <td><?php echo e($job->created_at); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="card">
            <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:10px">
                <strong>آخر الطلبات</strong>
                <a class="btn" href="<?php echo e(route('admin.applications.index')); ?>">المزيد</a>
            </div>
            <table class="table">
                <thead>
                <tr>
                    <th>الوظيفة</th>
                    <th>الحالة</th>
                    <th>بتاريخ</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = \App\Models\JobApplication::with('job')->latest('id')->limit(6)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(optional($app->job)->job_title); ?></td>
                        <td><span class="badge"><?php echo e($app->status); ?></span></td>
                        <td><?php echo e($app->applied_at); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/masterhr/public_html/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>