

<?php $__env->startSection('title','الشركات'); ?>
<?php $__env->startSection('page-title','الشركات'); ?>

<?php $__env->startSection('content'); ?>
    <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:16px">
        <form method="get" action="" style="display:flex;gap:8px">
            <input name="q" value="<?php echo e(request('q')); ?>" placeholder="ابحث بالاسم أو القطاع أو المدينة" style="background:#0b1220;border:1px solid #1f2937;color:#e2e8f0;padding:10px 12px;border-radius:10px;min-width:260px">
            <button class="btn" type="submit"><i class="fa-solid fa-magnifying-glass"></i> بحث</button>
        </form>
        <a class="btn" href="<?php echo e(route('admin.companies.create')); ?>"><i class="fa-solid fa-plus"></i> شركة جديدة</a>
    </div>
    <table class="table">
        <thead>
        <tr>
            <th>الاسم</th>
            <th>القطاع</th>
            <th>المدينة</th>
            <th>موثّقة</th>
            <th>التقييم</th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><a href="<?php echo e(route('admin.companies.show',$company)); ?>"><?php echo e($company->company_name); ?></a></td>
                <td><?php echo e($company->industry); ?></td>
                <td><?php echo e($company->location); ?></td>
                <td><?php echo $company->is_verified ? '<span class="badge">نعم</span>' : '<span class="badge">لا</span>'; ?></td>
                <td><?php echo e(number_format($company->rating,2)); ?></td>
                <td style="text-align:end">
                    <a class="btn" href="<?php echo e(route('admin.companies.edit',$company)); ?>"><i class="fa-solid fa-pen"></i> تعديل</a>
                    <form action="<?php echo e(route('admin.companies.destroy',$company)); ?>" method="post" style="display:inline-block" onsubmit="return confirm('حذف الشركة؟');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('delete'); ?>
                        <button class="btn" type="submit"><i class="fa-solid fa-trash"></i> حذف</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <div style="margin-top:12px"><?php echo e($companies->links()); ?></div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Eng.Mohamed-Ashraf\Desktop\git\Master-HR-Laravel\resources\views/admin/companies/index.blade.php ENDPATH**/ ?>